//
//  MCAttributedStringDisplayView.h
//  MCApplication
//
//  Created by Ali Lalani on 9/2/04.
//  Copyright 2004 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface MCAttributedStringDisplayView : NSView {
	NSAttributedString *attrDisplayString;
	NSDictionary *attributes;
	
	NSTextAlignment alignment;
	BOOL verticallyCentered;
}

- (id)initWithFrame:(NSRect)r alignment:(NSTextAlignment)align verticallyCenter:(BOOL)vFlag attributes:(NSDictionary *)attr;

- (NSAttributedString *)attrDisplayString;
- (void)setAttrDisplayString:(NSAttributedString *)anAttrDisplayString;

- (NSDictionary *)attributes;
- (void)setAttributes:(NSDictionary *)anAttributes;

- (NSTextAlignment)alignment;
- (void)setAlignment:(NSTextAlignment)anAlignment;

- (BOOL)verticallyCentered;
- (void)setVerticallyCentered:(BOOL)flag;

- (void)setDisplayString:(NSString *)aString;
@end
